/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;
import oracle.ops.verification.framework.util.OraInvHome;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OUIData {
    static final String TAG_INVENTORY_ROOT = "INVENTORY";
    static final String TAG_HOMELIST = "HOME_LIST";
    static final String TAG_HOME = "HOME";
    static final String TAG_NODELIST = "NODE_LIST";
    static final String TAG_NODE = "NODE";
    static final String TAG_NAME = "NAME";
    static final String TAG_LOC = "LOC";
    static final String TAG_CRS = "CRS";
    static final String TAG_TYPE = "TYPE";
    static final String TAG_REMOVED = "REMOVED";
    private static boolean m_valid = false;
    private String m_invFile;
    private Hashtable m_oraHomes = new Hashtable();
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private OraInvHome m_crsHome = null;
    private static OUIData m_thisInstance = null;

    private OUIData(String filename) throws InvalidOUIInventoryDataException {
        this.m_invFile = filename;
        this.readInventoryData();
    }

    public static OUIData getInstance() {
        if (!m_valid) {
            throw new IllegalStateException("OUIData has not been initialized");
        }
        return m_thisInstance;
    }

    public static OUIData getInstance(String filename) throws InvalidOUIInventoryDataException {
        if (m_thisInstance != null) {
            return m_thisInstance;
        }
        m_thisInstance = new OUIData(filename);
        m_valid = true;
        return m_thisInstance;
    }

    public boolean isCRSInstalled() {
        return this.m_crsHome != null;
    }

    public String getCRSHomeLocation() {
        if (this.m_crsHome == null) {
            return null;
        }
        return this.m_crsHome.getLocation();
    }

    public String[] getOracleHomeLocations() {
        if (this.m_oraHomes == null) {
            return null;
        }
        String[] locs = new String[this.m_oraHomes.size()];
        Enumeration e = this.m_oraHomes.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            locs[i] = ((OraInvHome)e.nextElement()).getLocation();
            ++i;
        }
        return locs;
    }

    public boolean isCRSInstalledOnNode(String node) {
        if (this.m_crsHome == null) {
            return false;
        }
        boolean found = false;
        String[] nodes = this.getNodesAsStrArr(this.m_crsHome);
        int dotIdx = node.indexOf(".");
        String nodeNoDomain = node;
        if (dotIdx != -1) {
            nodeNoDomain = node.substring(0, dotIdx);
        }
        for (int i = 0; i < nodes.length; ++i) {
            String crsNdWODmn = VerificationUtil.getShortHostname(nodes[i]);
            if (!node.equalsIgnoreCase(nodes[i]) && !nodeNoDomain.equalsIgnoreCase(nodes[i]) && !nodeNoDomain.equalsIgnoreCase(crsNdWODmn)) continue;
            found = true;
            Trace.out((String)("==== CRS is installed on " + node));
            break;
        }
        return found;
    }

    public String[] getCRSNodes() {
        return this.getNodesAsStrArr(this.m_crsHome);
    }

    public boolean isaCRSHome(String loc) {
        return this.m_crsHome != null && this.m_crsHome.getLocation().equalsIgnoreCase(loc);
    }

    public boolean isaOracleHome(String loc) {
        if (this.m_oraHomes == null) {
            return false;
        }
        boolean matched = false;
        Enumeration e = this.m_oraHomes.elements();
        while (e.hasMoreElements()) {
            OraInvHome home = (OraInvHome)e.nextElement();
            if (!home.getLocation().equalsIgnoreCase(loc)) continue;
            matched = true;
            break;
        }
        return matched;
    }

    private void readInventoryData() throws InvalidOUIInventoryDataException {
        boolean crsHomeFound = false;
        String errMsg = "";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            DefaultHandler handler = new DefaultHandler();
            parser.setErrorHandler(handler);
            Document doc = parser.parse("file:" + this.m_invFile);
            Element rootElm = doc.getDocumentElement();
            String rootElmStr = rootElm.getTagName();
            if (!rootElmStr.equalsIgnoreCase(TAG_INVENTORY_ROOT)) {
                Trace.out((String)("ERROR: Invalid root element " + rootElmStr));
                throw new InvalidOUIInventoryDataException("Invalid root element '" + rootElmStr + "'");
            }
            NodeList all_homelist = rootElm.getElementsByTagName(TAG_HOMELIST);
            Trace.out((String)("==== " + all_homelist.getLength() + "'" + TAG_HOMELIST + "' found in " + this.m_invFile));
            if (all_homelist.getLength() <= 0) {
                Trace.out((String)("==== HOMELIST does not exist in " + this.m_invFile));
                return;
            }
            Element hmListElm = (Element)all_homelist.item(0);
            NodeList allHomes = hmListElm.getElementsByTagName(TAG_HOME);
            Trace.out((String)("==== " + allHomes.getLength() + "'" + TAG_HOME + "' found in " + this.m_invFile));
            for (int k = 0; k < allHomes.getLength(); ++k) {
                Element home = (Element)allHomes.item(k);
                String homeName = home.getAttribute(TAG_NAME);
                String homeLoc = home.getAttribute(TAG_LOC);
                String homeRmStat = home.getAttribute(TAG_REMOVED);
                boolean isHomeRemoved = false;
                boolean isCrsHome = false;
                if (VerificationUtil.isStringGood(homeRmStat)) {
                    isHomeRemoved = homeRmStat.equalsIgnoreCase("T");
                }
                Vector nodes_v = null;
                String homeCrs = home.getAttribute(TAG_CRS);
                if (VerificationUtil.isStringGood(homeCrs)) {
                    isCrsHome = homeCrs.equalsIgnoreCase("true");
                    crsHomeFound = isCrsHome ? isCrsHome : crsHomeFound;
                } else if (!isHomeRemoved && VerificationUtil.isStringGood(homeLoc)) {
                    String curVersion = null;
                    ClusterwareInfo clwInfo = new ClusterwareInfo();
                    try {
                        Version version = clwInfo.getSRVCTLVersion(homeLoc);
                        curVersion = version.toString4();
                    }
                    catch (InstallException cie) {
                        Trace.out((String)"Caught InstallException");
                        Trace.out((String)("Failed to get SRVCTL Version for home location " + homeLoc + " The error is => " + cie.getMessage()));
                    }
                    if (VerificationUtil.isStringGood(curVersion) && VerificationUtil.isVersionPost(curVersion, "11.2")) {
                        String crsHomePropertyOlr = null;
                        Result result = new Result("localnode");
                        crsHomePropertyOlr = VerificationUtil.getOLRPropertyValueLocalNode("crs_home", result, true);
                        if (result.getStatus() != 1 && !crsHomeFound) {
                            List<VerificationError> errors = result.getErrors();
                            for (VerificationError err : errors) {
                                errMsg = errMsg + (VerificationUtil.isStringGood(err.getErrorMessage()) ? Constants.LINE_SEPARATOR + err.getErrorMessage() : "");
                            }
                        }
                        if (VerificationUtil.isStringGood(crsHomePropertyOlr) && crsHomePropertyOlr.trim().equals(homeLoc.trim())) {
                            isCrsHome = true;
                            crsHomeFound = true;
                        }
                    } else {
                        Trace.out((String)"Either CRS version could not be determined  Or CRS is Pre 11.2.0 and Inventory does not have CRS=TRUE entry.");
                        Trace.out((String)("Could not determine if the home " + homeLoc + " is CRS Home or Not"));
                    }
                } else {
                    Trace.out((String)("==== ORACLE home marked 'removed'. Skipping : " + homeLoc));
                    continue;
                }
                NodeList allNodelist = home.getElementsByTagName(TAG_NODELIST);
                nodes_v = allNodelist.getLength() <= 0 ? new Vector(1) : this.getOraHomeNodes((Element)allNodelist.item(0));
                OraInvHome oihome = null;
                if (isCrsHome) {
                    this.m_crsHome = oihome = new OraInvHome(homeName, homeLoc, 1, nodes_v);
                    Trace.out((String)("==== CRS home added: " + oihome));
                    continue;
                }
                oihome = new OraInvHome(homeName, homeLoc, 2, nodes_v);
                this.m_oraHomes.put(homeName, oihome);
                Trace.out((String)("==== ORACLE home added: " + oihome));
            }
            if (!crsHomeFound && VerificationUtil.isStringGood(errMsg)) {
                Trace.out((String)("CRS Home not found in Inventory, failed with error " + errMsg));
                throw new InvalidOUIInventoryDataException(errMsg);
            }
        }
        catch (SAXException e) {
            String errtxt = "'" + this.m_invFile + " is not well-formed. ";
            throw new InvalidOUIInventoryDataException(errtxt + e.getMessage());
        }
        catch (IOException e) {
            throw new InvalidOUIInventoryDataException(e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new InvalidOUIInventoryDataException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new InvalidOUIInventoryDataException(e.getMessage());
        }
    }

    private Vector getOraHomeNodes(Element ndlist) {
        Vector<String> nodes = new Vector<String>();
        NodeList allNodes = ndlist.getElementsByTagName(TAG_NODE);
        for (int i = 0; i < allNodes.getLength(); ++i) {
            Element aNode = (Element)allNodes.item(i);
            String nodename = aNode.getAttribute(TAG_NAME);
            if (nodename == null || nodename.trim().length() <= 1) continue;
            nodes.add(nodename);
        }
        return nodes;
    }

    protected String[] getNodesAsStrArr(OraInvHome home) {
        if (home == null) {
            return null;
        }
        String[] nodes = home.getNodelistAsStrArr();
        return nodes;
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.out.println("ERROR: Provide the OUI inventory file as the first arg");
            return;
        }
        try {
            OUIData.getInstance(args[0]);
            OUIData ouiData = OUIData.getInstance();
            System.out.println("Is CRS installed? " + ouiData.isCRSInstalled());
            System.out.println("Get CRS home. " + ouiData.getCRSHomeLocation());
            System.out.println("Get CRS Nodes: ");
            String[] crsNodes = ouiData.getCRSNodes();
            for (int i = 0; i < crsNodes.length; ++i) {
                System.out.println("\t" + crsNodes[i]);
            }
            System.out.println("All OHs: ");
            String[] ohomes = ouiData.getOracleHomeLocations();
            for (int k = 0; k < ohomes.length; ++k) {
                System.out.println("\t" + ohomes[k]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

